/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	SoundTrack
**
** DESCRIPTION:	Sound track
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SOUND_TRACK_H
#define SOUND_TRACK_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwSound.h"

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum ESoundTrack
{
	eSoundTrack_None = -1,

	eSoundTrack_Menu,
	eSoundTrack_Song1,
	eSoundTrack_Song2,
	eSoundTrack_Song3,
	eSoundTrack_Song4,

	eSoundTrack_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSoundTrack
{
private:
    
	//class data
	static char *		m_sSoundTrackFile[eSoundTrack_NumberOf];
	ldwSoundTrack *		m_pSoundTrack[eSoundTrack_NumberOf];

	ldwSoundTrack *		m_pCurrentSoundTrack;
	float				m_fVolume;

public:

	//class methods
	//setup
	public:		CSoundTrack();
	public:		~CSoundTrack();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	
	//process
	public:		void Start(const bool bPlayIntro);
	public:		void Stop();

	public:		void Update(ESoundTrack eTrackToForce);

	//access
	public:		void SetVolume(const float fVolume) { if (m_pCurrentSoundTrack) m_pCurrentSoundTrack->SetVolume(fVolume); m_fVolume = fVolume; }
	public:		const float Volume() { return m_fVolume; }
	public:		const bool IsPlaying(const ESoundTrack eSoundTrack) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSoundTrack		SoundTrack;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/